<?php
include( 'ayarlar.php' );
ini_set( 'display_errors', 1 );
ini_set( 'display_startup_errors', 1 );
error_reporting( E_ALL );

/* Kategorileri çek (üst kategori = 0) */
$stmt = $db->prepare( "
    SELECT kategoriId, kategori_adi, sira, ust_kategori
    FROM kategoriler
    WHERE ust_kategori = 0
    ORDER BY sira ASC, kategori_adi ASC
" );
$stmt->execute();
$KATEGORILER = $stmt->fetchAll( PDO::FETCH_ASSOC );

/* (Opsiyonel) Görseller kök klasörü – sadece gerektiğinde değiştirin */
$IMG_BASE = ''; // örn: '/uploads/';

/* İlk kategori id'si (sekme için) */
$ILK_ID = isset( $KATEGORILER[ 0 ][ 'kategoriId' ] ) ? ( int )$KATEGORILER[ 0 ][ 'kategoriId' ] : 0;
?>
<!DOCTYPE html>
<html lang="tr">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Sandro Coffee</title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<style>
:root {
--bg:#0f0f10;
--panel:#151518;
--muted:#a0a3ad;
--ink:#f2f3f7;
--brand:#f38f53;
--ring:rgba(255,180,1,.45);
--line:#232329;
--radius:16px;
    color-scheme: dark light
}
* {
    box-sizing: border-box
}
html, body {
    height: 100%
}
body {
    margin: 0;
    font-family: Inter, system-ui, Segoe UI, Roboto, Helvetica, Arial, sans-serif;
    background: linear-gradient(180deg, #0b0c0e 0%, #111215 40%, #0b0c0e 100%);
    color: var(--ink)
}
.hero {
    position: relative;
    background: url('menuarkaplan.jpg') center/cover no-repeat;
    min-height: 220px;
    display: flex;
    align-items: flex-end;
    border-bottom: 1px solid var(--line);
    isolation: isolate
}
.hero::after {
    content: "";
    position: absolute;
    inset: 0;
    background: linear-gradient(180deg, rgba(0,0,0,.1) 0, rgba(0,0,0,.65) 60%, rgba(0,0,0,.9) 100%);
    z-index: 0
}
.hero-inner {
    position: relative;
    z-index: 1;
    display: flex;
    gap: 16px;
    align-items: center;
    padding: 20px 16px;
    width: 100%;
    max-width: 1024px;
    margin-inline: auto
}
.logo {
    width: 64px;
    height: 64px;
    border-radius: 14px;
    overflow: hidden;
    flex: none;
    border: 1px solid rgba(255,255,255,.15);
    box-shadow: 0 6px 24px rgba(0,0,0,.45)
}
.logo img {
    width: 100%;
    height: 100%;
    object-fit: cover
}
.hero-text {
    display: flex;
    flex-direction: column;
    gap: 6px
}
.hero-title {
    font-size: clamp(20px, 1.6rem, 28px);
    font-weight: 700;
    letter-spacing: .3px
}
.hero-sub {
    font-size: 14px;
    color: var(--muted)
}
.topbar {
    position: sticky;
    top: 0;
    z-index: 50;
    backdrop-filter: blur(8px);
    background: rgba(10,10,12,.6);
    border-bottom: 1px solid var(--line)
}
.topbar-inner {
    max-width: 1024px;
    margin: auto;
    padding: 10px 12px;
    display: flex;
    align-items: center;
    gap: 10px
}
.search {
    position: relative;
    flex: 1
}
.search input {
    width: 100%;
    background: #0f1013;
    border: 1px solid #202126;
    border-radius: 12px;
    height: 40px;
    padding: 0 40px 0 12px;
    color: var(--ink)
}
.search svg {
    position: absolute;
    right: 10px;
    top: 50%;
    transform: translateY(-50%);
    opacity: .7
}
.tabs {
    position: sticky;
    top: 60px;
    z-index: 40;
    background: linear-gradient(180deg, rgba(15,15,16,1), rgba(15,15,16,.7));
    border-bottom: 1px solid var(--line)
}
.tabs-inner {
    max-width: 1024px;
    margin: auto;
    display: flex;
    gap: 8px;
    overflow: auto;
    scrollbar-width: none;
    padding: 10px 12px
}
.tabs-inner::-webkit-scrollbar {
display:none
}
.tab {
    white-space: nowrap;
    padding: 8px 14px;
    background: #131317;
    color: var(--muted);
    border: 1px solid #1f2027;
    border-radius: 999px;
    cursor: pointer;
    transition: .2s
}
.tab.active {
    color: #111;
    background: var(--brand);
    border-color: var(--brand)
}
.section {
    max-width: 1024px;
    margin: 24px auto;
    padding: 0 12px
}
.section h2 {
    margin: 10px 0 14px;
    font-size: 20px
}
.placeholder {
    font-size: 13.5px;
    color: var(--muted);
    background: #121319;
    border: 1px dashed #252730;
    border-radius: 12px;
    padding: 14px
}
.grid {
    display: grid;
    grid-template-columns: repeat(1, minmax(0, 1fr));
    gap: 12px
}

@media(min-width:560px) {
.grid {
    grid-template-columns: repeat(2, minmax(0, 1fr))
}
}

@media(min-width:900px) {
.grid {
    grid-template-columns: repeat(3, minmax(0, 1fr))
}
}
.card {
    display: flex;
    gap: 12px;
    background: linear-gradient(180deg, #15161a, #111216);
    border: 1px solid #1f2127;
    border-radius: 14px;
    padding: 10px;
    position: relative;
    overflow: hidden;
    align-items: center; /* fiyat ile aynı hizada */
}
.thumb {
    width: 96px;
    height: 96px;
    border-radius: 12px;
    overflow: hidden;
    flex: none;
    background: #0a0b0d;
    border: 1px solid #24262d
}
.thumb img {
    width: 100%;
    height: 100%;
    object-fit: cover
}
.meta {
    display: flex;
    flex-direction: column;
    gap: 6px;
    min-width: 0;
    flex: 1
}
.title {
    font-weight: 600;
    line-height: 1.25
}
.desc {
    font-size: 12.5px;
    color: var(--muted);
    line-height: 1.4;
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden
}
a {
    color: inherit
}
/* SAĞDA FİYAT KUTUSU */
.price-box {
    margin-left: auto;
    background: var(--brand);
    color: #111;
    font-weight: 700;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 6px 14px;
    border-radius: 999px;
    white-space: nowrap;
    min-width: 90px;
    font-size: 15px;
    box-shadow: 0 2px 6px rgba(0,0,0,.25);
    transition: transform .15s ease, box-shadow .15s ease;
}
.price-box:hover {
    transform: scale(1.05);
    box-shadow: 0 4px 10px rgba(0,0,0,.35);
}
.price-box span {
    font-size: 13px;
    margin-left: 3px;
}
</style>
</head>
<body>
<header class="hero">
  <div class="hero-inner">
    <div class="hero-text">
      <div class="hero-title">Sandro Coffee</div>
    </div>
  </div>
</header>
<div class="topbar">
  <div class="topbar-inner">
    <div class="search">
      <input id="search" type="search" placeholder="Ürün ara (örn. Matcha, Latte)…" />
      <svg width="22" height="22" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M21 21L15.8 15.8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"/>
        <circle cx="11" cy="11" r="6.25" stroke="currentColor" stroke-width="1.5"/>
      </svg>
    </div>
  </div>
</div>

<!-- KATEGORİ SEKMELERİ -->
<nav class="tabs" aria-label="Kategoriler">
  <div class="tabs-inner" id="tabs">
    <?php if(empty($KATEGORILER)): ?>
    <span style="color:var(--muted)">Kategori bulunamadı.</span>
    <?php else: foreach($KATEGORILER as $i=>$kat): ?>
    <button class="tab<?= $i===0 ? ' active':'' ?>" data-id="<?= (int)$kat['kategoriId'] ?>">
    <?= htmlspecialchars($kat['kategori_adi']) ?>
    </button>
    <?php endforeach; endif; ?>
  </div>
</nav>

<!-- İÇERİK BÖLÜMLERİ -->
<main id="content">
  <?php foreach($KATEGORILER as $i=>$kat): ?>
  <section class="section" id="sec-<?= (int)$kat['kategoriId'] ?>" <?= $i!==0 ? 'style="display:none"':'' ?>>
    <h2>
      <?= htmlspecialchars($kat['kategori_adi']) ?>
    </h2>
    <?php
    // Bu kategoriye bağlı ürünler (urunler.hit = kategoriler.kategoriId)
    try {
        $urunStmt = $db->prepare( "
            SELECT 
              Id AS id,
              urunadi,
              fiyat,
              aciklama,
              CASE WHEN mini IS NOT NULL AND mini <> '' THEN mini ELSE resim END AS gorsel
            FROM urunler
            WHERE hit = :hid
            ORDER BY urunadi ASC
        " );
        $urunStmt->execute( [ ':hid' => ( int )$kat[ 'kategoriId' ] ] );
        $urunler = $urunStmt->fetchAll( PDO::FETCH_ASSOC );
    } catch ( Throwable $e ) {
        error_log( 'URUN SORGU HATASI: ' . $e->getMessage() );
        $urunler = [];
    }
    ?>
    <?php if (!empty($urunler)): ?>
    <div class="grid">
      <?php
      foreach ( $urunler as $u ):
          $ad = isset( $u[ 'urunadi' ] ) ? ( string )$u[ 'urunadi' ] : 'Ürün';
      $fiyat = isset( $u[ 'fiyat' ] ) && is_numeric( $u[ 'fiyat' ] ) ? ( float )$u[ 'fiyat' ] : 0;
      $descRaw = isset( $u[ 'aciklama' ] ) ? $u[ 'aciklama' ] : '';
      $desc = trim( strip_tags( html_entity_decode( $descRaw, ENT_QUOTES, 'UTF-8' ) ) );
      $imgName = isset( $u[ 'gorsel' ] ) ? trim( $u[ 'gorsel' ] ) : '';
      $img = $imgName !== '' ? $IMG_BASE . $imgName : $IMG_BASE . 'noimage.jpg';
      $dataTitle = strtolower( $ad );
      ?>
      <article class="card" data-title="<?= htmlspecialchars($dataTitle) ?>">
        <div class="thumb"> <img src="upload/resimler/<?= htmlspecialchars($img) ?>" alt="<?= htmlspecialchars($ad) ?>"> </div>
        <div class="meta">
          <div class="title">
            <?= htmlspecialchars($ad) ?>
          </div>
          <?php if($desc): ?>
          <div class="desc">
            <?= htmlspecialchars($desc) ?>
          </div>
          <?php endif; ?>
        </div>
        <?php if($fiyat > 0): ?>
        <div class="price-box">
          <?= number_format($fiyat, 0, ',', '.') ?>
          <span>₺</span> </div>
        <?php endif; ?>
      </article>
      <?php endforeach; ?>
    </div>
    <?php else: ?>
    <div class="placeholder">Bu kategoriye ait ürün bulunamadı.</div>
    <?php endif; ?>
  </section>
  <?php endforeach; ?>
</main>
<p style="text-align: center;
  background: #1f2127;
  padding: 10px;"><a href="https://mergensoft.com" target="_blank" style="text-decoration: none;font-size: 12px;">Designed by Mergensoft Yazılım ve Tasarım</a></p>
<script>
// Arama: sadece görünen bölümde data-title'a göre filtreler
function filterProducts(q){
  q = (q || '').trim().toLowerCase();
  const $scope = $('#content .section:visible');
  if(!q){ $scope.find('[data-title]').show(); return; }
  $scope.find('[data-title]').each(function(){
    const t = ($(this).attr('data-title') || '').toLowerCase();
    $(this).toggle(t.includes(q));
  });
}
$(document).on('input','#search', e=> filterProducts(e.target.value));

// Sekme davranışı: yalnızca seçilen kategori görünür
$(document).on('click','.tab',function(){
  $('.tab').removeClass('active'); $(this).addClass('active');
  const id = $(this).data('id');
  $('.section').hide();
  $('#sec-'+id).show();
  $('#search').val('');
  filterProducts('');
});
</script>
</body>
</html>
